<?php
// Simple IPA Manager - AppInstall-like
// Place your IPA files in ./ota/
function format_bytes($bytes) {
  $units = ['B','KB','MB','GB','TB'];
  $i = 0;
  while ($bytes >= 1024 && $i < count($units)-1){ $bytes /= 1024; $i++; }
  return number_format($bytes, ($i>=2?2:0)) . ' ' . $units[$i];
}
function base_url() {
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $path = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
  return $scheme . '://' . $host . ($path ? $path : '');
}
$free = @disk_free_space(__DIR__);
$total = @disk_total_space(__DIR__);
$free_txt = $free ? format_bytes($free) : 'n/a';
$ota_dir = __DIR__ . '/ota';
$files = glob($ota_dir . '/*.ipa');
natsort($files);
$items = [];
foreach ($files as $f) {
  $name = basename($f);
  $size = filesize($f);
  $items[] = [
    'name' => $name,
    'size' => format_bytes($size),
    'url'  => base_url() . '/ota/' . rawurlencode($name)
  ];
}
?>
<!doctype html>
<html lang="vi">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Quản lý tệp IPA</title>
<link rel="stylesheet" href="./assets/css/style.css">
</head>
<body>
<header class="top">
  <div class="brand">
    <img src="./assets/img/logo.svg" alt="Logo">
    <strong>Quản lý tệp IPA</strong>
  </div>
  <nav class="nav">
    <a class="btn" href="#" id="speedBtn">Đo tốc độ</a>
  </nav>
</header>

<main class="wrap">
  <div class="stat">
    <span>Dung lượng trống trên máy chủ:</span>
    <b><?= htmlspecialchars($free_txt) ?></b>
    <span id="speedInfo"> · Đang đo tốc độ mạng...</span>
  </div>

  <section class="card">
    <h3>Danh sách IPA</h3>
    <div class="toolbar">
      <input id="search" type="search" placeholder="Tìm file...">
      <span class="count" id="count"></span>
    </div>

    <div class="table">
      <div class="thead">
        <div>Tên file</div><div>Kích thước</div><div>Hành động</div>
      </div>
      <div id="tbody">
        <?php foreach ($items as $it): ?>
        <div class="row" data-name="<?= htmlspecialchars(strtolower($it['name'])) ?>">
          <div class="name" title="<?= htmlspecialchars($it['name']) ?>"><?= htmlspecialchars($it['name']) ?></div>
          <div class="size"><?= htmlspecialchars($it['size']) ?></div>
          <div class="actions">
            <a class="btn" href="<?= htmlspecialchars($it['url']) ?>">Tải xuống</a>
            <button class="btn ghost" data-copy="<?= htmlspecialchars($it['url']) ?>">Sao chép liên kết</button>
          </div>
        </div>
        <?php endforeach; ?>
        <?php if (empty($items)): ?>
        <div class="empty">Chưa có tệp nào. Hãy upload .ipa vào thư mục <code>/ota/</code>.</div>
        <?php endif; ?>
      </div>
    </div>
  </section>

  <footer class="foot">
    <div>© <?= date('Y') ?> IPA | Liên Quân - PUBG - Chấp Tố Độc Quyền</div>
    <a class="zalo" href="https://zalo.me" target="_blank" rel="noopener">
      <img src="./assets/img/zalo.png" alt="Zalo" />
      Zalo
    </a>
  </footer>
</main>

<script src="./assets/js/app.js"></script>
</body>
</html>
