const copyBtns = document.querySelectorAll('button[data-copy]');
copyBtns.forEach(btn=>btn.addEventListener('click', async ()=>{
  const url = btn.getAttribute('data-copy');
  try { await navigator.clipboard.writeText(url); btn.textContent='Đã sao chép'; setTimeout(()=>btn.textContent='Sao chép liên kết',1600); }
  catch(e){ prompt('Sao chép liên kết:', url); }
}));

// Search filter + counter
const rows = Array.from(document.querySelectorAll('#tbody .row'));
const search = document.getElementById('search');
const count = document.getElementById('count');
const updateCount = () => {
  const q = (search.value||'').trim().toLowerCase();
  let visible = 0;
  rows.forEach(r=>{
    const ok = r.dataset.name.includes(q);
    r.style.display = ok ? '' : 'none';
    if (ok) visible++;
  });
  count.textContent = visible + ' / ' + rows.length + ' tệp';
};
search?.addEventListener('input', updateCount);
updateCount();

// Simple speed test (~1MiB)
function fmtMbps(bytes, ms){ const bps = (bytes * 8) / (ms/1000); return (bps/1e6).toFixed(2) + ' Mbps'; }
async function testSpeed(){
  const info = document.getElementById('speedInfo');
  const btn = document.getElementById('speedBtn');
  btn.textContent = 'Đang đo...';
  const url = './assets/speed.bin?x=' + Date.now();
  const t0 = performance.now();
  const res = await fetch(url, {cache:'no-store'});
  const blob = await res.blob();
  const t1 = performance.now();
  const mbps = fmtMbps(blob.size, t1-t0);
  info.textContent = ' · Tốc độ mạng: ' + mbps;
  btn.textContent = 'Đo lại';
}
document.getElementById('speedBtn').addEventListener('click', (e)=>{e.preventDefault(); testSpeed();});
// Auto test on load (best effort)
testSpeed().catch(()=>{ document.getElementById('speedInfo').textContent=''; });
